/*
 * Decompiled with CFR 0.152.
 */
package com.foresee.open.sdk.client;

import com.foresee.open.sdk.constant.OpenApiConstants;
import com.foresee.open.sdk.exception.OpenApiClientException;
import com.foresee.open.sdk.kit.DigestKit;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class OpenApiHelper {
    public static boolean validateSign(String queryString, String signKey, OpenApiConstants.SignAlgorithm signMethod, String jsonData) {
        return OpenApiHelper.doValidateSign(queryString, signKey, signMethod, jsonData);
    }

    private static boolean doValidateSign(String queryString, String signKey, OpenApiConstants.SignAlgorithm signMethod, String jsonData) {
        Map<String, String> queryPairs = OpenApiHelper.queryStringToMap(queryString);
        String expectedSign = queryPairs.remove("sign");
        TreeMap<String, String> queryMap = new TreeMap<String, String>(queryPairs);
        String query = OpenApiHelper.getQueryString(queryMap);
        String actualSign = OpenApiHelper.calSign(query, signKey, signMethod, jsonData);
        return actualSign.equals(expectedSign);
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        try {
            String[] pairs;
            if (Strings.isNullOrEmpty(queryString)) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
            for (String pair : pairs = queryString.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            return queryPairs;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenApiClientException(queryString + "\u89e3\u7801\u5931\u8d25", e);
        }
    }

    public static String genQueryString(Map<String, ?> map, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String jsonData) {
        TreeMap queryMap = new TreeMap(map);
        String queryString = OpenApiHelper.getQueryString(queryMap);
        String signedText = OpenApiHelper.calSign(queryString, signKey, signAlgorithm, jsonData);
        queryString = queryString + "sign=" + signedText;
        return queryString;
    }

    private static String calSign(String queryString, String signKey, OpenApiConstants.SignAlgorithm signAlgorithm, String jsonData) {
        StringBuilder sb = new StringBuilder(queryString);
        String messageText = sb.append(jsonData).append("{").append(signKey).append("}").toString();
        if (signAlgorithm == OpenApiConstants.SignAlgorithm.SHA256) {
            byte[] bytes = DigestKit.sha256(messageText);
            return DigestKit.md5Hex(bytes).toUpperCase();
        }
        if (signAlgorithm == OpenApiConstants.SignAlgorithm.MD5) {
            return DigestKit.md5Hex(messageText.getBytes()).toUpperCase();
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u7b7e\u540d\u7b97\u6cd5\uff1a" + (Object)((Object)signAlgorithm));
    }

    private static String getQueryString(Map<String, ?> queryMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ?> entry : queryMap.entrySet()) {
            String valueStr;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = valueStr = value == null ? "" : value.toString();
            if (valueStr.trim().equals("")) continue;
            sb.append(key).append("=").append(valueStr).append("&");
        }
        return sb.toString();
    }

    public static URI getUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new OpenApiClientException(url + "\u4e0d\u662f\u4e00\u4e2a\u5b8c\u6574\u7684url", e);
        }
    }
}

